% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{dm_get_referencing_tables}
\alias{dm_get_referencing_tables}
\title{Get the names of referencing tables}
\usage{
dm_get_referencing_tables(dm, table)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.}
}
\value{
A character vector of the names of the tables that point to the primary
key of \code{table}.
}
\description{
This function returns the names of all tables that point to the primary key
of a table.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_get_referencing_tables(airports)
dm_nycflights13() \%>\%
  dm_get_referencing_tables(flights)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions utilizing foreign key relations: 
\code{\link{dm_is_referenced}()}
}
\concept{functions utilizing foreign key relations}
