% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr.R
\name{tidyr_table_manipulation}
\alias{tidyr_table_manipulation}
\alias{unite.dm_zoomed}
\alias{unite.dm_keyed_tbl}
\alias{separate.dm_zoomed}
\alias{separate.dm_keyed_tbl}
\title{\pkg{tidyr} table manipulation methods for zoomed dm objects}
\usage{
\method{unite}{dm_zoomed}(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)

\method{unite}{dm_keyed_tbl}(data, ...)

\method{separate}{dm_zoomed}(data, col, into, sep = "[^[:alnum:]]+", remove = TRUE, ...)

\method{separate}{dm_keyed_tbl}(data, ...)
}
\arguments{
\item{data}{object of class \code{dm_zoomed}}

\item{col}{For \code{unite.dm_zoomed}: see \code{\link[tidyr:unite]{tidyr::unite()}}

For \code{separate.dm_zoomed}: see \code{\link[tidyr:separate]{tidyr::separate()}}}

\item{...}{For \code{unite.dm_zoomed}: see \code{\link[tidyr:unite]{tidyr::unite()}}

For \code{separate.dm_zoomed}: see \code{\link[tidyr:separate]{tidyr::separate()}}}

\item{sep}{For \code{unite.dm_zoomed}: see \code{\link[tidyr:unite]{tidyr::unite()}}

For \code{separate.dm_zoomed}: see \code{\link[tidyr:separate]{tidyr::separate()}}}

\item{remove}{For \code{unite.dm_zoomed}: see \code{\link[tidyr:unite]{tidyr::unite()}}

For \code{separate.dm_zoomed}: see \code{\link[tidyr:separate]{tidyr::separate()}}}

\item{na.rm}{see \code{\link[tidyr:unite]{tidyr::unite()}}}

\item{into}{see \code{\link[tidyr:separate]{tidyr::separate()}}}
}
\description{
Use these methods without the '.dm_zoomed' suffix (see examples).
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
zoom_united <- dm_nycflights13() \%>\%
  dm_zoom_to(flights) \%>\%
  select(year, month, day) \%>\%
  unite("month_day", month, day)
zoom_united
zoom_united \%>\%
  separate(month_day, c("month", "day"))
\dontshow{\}) # examplesIf}
}
