% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_fit.R
\name{dmbc_fit}
\alias{dmbc_fit}
\title{Fitter function for DMBC models.}
\usage{
dmbc_fit(D, p, G, family, control, prior, start)
}
\arguments{
\item{D}{A list whose elements are the dissimilarity matrices corresponding
to the judgments expressed by the \emph{S} subjects/raters. These matrices
must be defined as a \code{dist} object.}

\item{p}{A length-one numeric vector indicating the number of dimensions of the
latent space.}

\item{G}{A length-one numeric vector indicating the number of cluster to
partition the \emph{S} subjects.}

\item{family}{A length-one character vector representing the type of data to
analyze. Currently, it accepts only the 'binomial' value, but future
developments will include the possibility to analyze continuous,
multinomial and count data.}

\item{control}{A list of control parameters that affect the sampling
but do not affect the posterior distribution See
\code{\link{dmbc_control}()} for more details.}

\item{prior}{A list containing the prior hyperparameters. See
\code{\link{dmbc_prior}()} for more details.}

\item{start}{A named list of starting values for the MCMC algorithm (see
\code{\link{dmbc_init}}).}
}
\value{
A \code{dmbc_fit_list} object.
}
\description{
\code{dmbc_fit()} is the main function that estimates a DMBC model.
}
\examples{
\donttest{
data(simdiss, package = "dmbc")

G <- 3
p <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 20000
nsim <- 10000
seed <- 2301

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], random.start = TRUE, verbose = TRUE,
  nchains = 2, thin = 10, store.burnin = TRUE, threads = 2,
  parallel = "snow")
sim.dmbc <- dmbc(simdiss, p, G, control)

summary(sim.dmbc, include.burnin = FALSE)

library(bayesplot)
library(ggplot2)
color_scheme_set("teal")
plot(sim.dmbc, what = "trace", regex_pars = "eta")

z <- dmbc_get_configuration(sim.dmbc, chain = 1, est = "mean",
  labels = 1:16)
summary(z)
color_scheme_set("mix-pink-blue")
graph <- plot(z, size = 2, size_lbl = 3)
graph + panel_bg(fill = "gray90", color = NA)
}
}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link{dmbc_data}} for a description of the data format.

\code{\link{dmbc_fit_list}} for a description of the elements
  included in the returned object.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
