% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{choose_test.date}
\alias{choose_test.date}
\title{Filter final result}
\usage{
\method{choose_test}{date}(obj, test = "out", group_id = T)
}
\arguments{
\item{obj}{An object for calculation. Class date.}

\item{test}{A character scalar. Parameters, which use to filter the final dataset, default: "out":
"out" - dates, which are out of the protocol's timeline,
"uneq" - dates, which are unequal,
"ok" - correct dates,
"skip" - empty dates.}

\item{group_id}{A logical scalar, default is TRUE.True is grouped by id, otherwise, it isn't grouped.}
}
\value{
The dataset by a value of \code{test}.
}
\description{
Filter final result
}
\examples{
id <- c("01", "02", "03")
screen_date_E1 <- c("1991-03-13", "1991-03-07", "1991-03-08")
rand_date_E2 <- c("1991-03-15", "1991-03-11", "1991-03-10")
ph_date_E3 <- c("1991-03-21", "1991-03-16", "1991-03-16")
bio_date_E3 <- c("1991-03-23", "1991-03-16", "1991-03-16")

df <- data.frame(id, screen_date_E1, rand_date_E2, ph_date_E3, bio_date_E3,
  stringsAsFactors = FALSE
)

timeline <- system.file("dates.xlsx", package = "dmtools")
obj_date <- date(timeline, id, dplyr::contains)

obj_date <- check(obj_date, df)
choose_test(obj_date, "out")
}
