% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice_imputers_censored.R
\name{mice.impute.cens}
\alias{mice.impute.cens}
\title{Impute left censored data with MICE}
\usage{
mice.impute.cens(
  y,
  ry,
  x,
  lod.j,
  lod.name = "lod",
  REDRAW = FALSE,
  wy = NULL,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the the subset
\code{y[ry]} of elements in y to which the imputation model is fitted.
The \code{ry} generally distinguishes the observed (\code{TRUE}) and
missing values (\code{FALSE}) in y.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors
for \code{y}. Matrix \code{x} may have no missing values.}

\item{lod.j}{censoring value.}

\item{lod.name}{suffix name used for the censored variable.}

\item{REDRAW}{Boolean indicating whether values should be redrawn if some
are over the censoring limit}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}.
}
\description{
Function from \code{Lapidus et al.} for imputing left-censored data with mice
}
