% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_dobin.R
\name{autoplot.dobin}
\alias{autoplot.dobin}
\title{Plots the first two components of the dobin space.}
\usage{
\method{autoplot}{dobin}(object, ...)
}
\arguments{
\item{object}{The output of the function `dobin`.}

\item{...}{Other arguments currently ignored.}
}
\value{
A ggplot object.
}
\description{
Scatterplot of the first two columns in the dobin space.
}
\examples{
X <- rbind(
  data.frame(x = rnorm(500),
             y = rnorm(500),
             z = rnorm(500)),
  data.frame(x = rnorm(5, mean = 10, sd = 0.2),
             y = rnorm(5, mean = 10, sd = 0.2),
             z = rnorm(5, mean = 10, sd = 0.2))
)
dob <- dobin(X)
autoplot(dob)
}
