% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_dependencies.R
\name{identify_dependencies}
\alias{identify_dependencies}
\title{Identify R Package Dependencies of Package}
\usage{
identify_dependencies(pkg = pkg, dependencies = c("Depends", "Imports",
  "LinkingTo"), base = FALSE, recommended = FALSE, verbose = TRUE)
}
\arguments{
\item{pkg}{Path to a package, or within a package.}

\item{dependencies}{character vector of dependency types to include.
    Choices are "Depends", "Imports", "LinkingTo", "Suggests",
    and "Enhances".  Defaults to \code{c("Depends", "Imports",
      "LinkingTo")}.
  }

\item{base}{Logical indicating whether to include dependencies on base
    packages that are included in the R installation. Defaults to
    FALSE.
    }

\item{recommended}{Logical indicating whether to include dependencies on
    recommended packages that are included in the R
    installation. Defaults to
    FALSE.
    }

\item{verbose}{\code{logical} should messages be printed or not?}
}
\value{
\code{list} with dependencies ordered recursively and a data.frame
with all R package dependencies with version numbers of the corresponding (1)
loaded or (2) installed packages.
}
\description{
Identifies the R package dependencies of a package and the version numbers of
the corresponding packages, that are currently loaded or installed.
}
