% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_pdf.R
\name{to_pdf}
\alias{to_pdf}
\title{Convert documents to pdf}
\usage{
to_pdf(
  input,
  output = gsub("\\\\.[[:alnum:]]+$", ".pdf", input),
  use_docx2pdf = FALSE
)
}
\arguments{
\item{input, output}{file input and optional file output. If output
file is not provided, the value will be the value of input file with
extension "pdf".}

\item{use_docx2pdf}{if TRUE (and if 'Microsoft Word' executable
can be found as well as 'docx2pdf'), docx2pdf will be used to
convert 'Word' documents to PDF. This makes it possible to have a
PDF identical to the 'Word' display whereas with 'LibreOffice', this
is not always the case.}
}
\value{
the name of the produced pdf (the same value as \code{output}),
invisibly.
}
\description{
Convert documents to pdf using Libre Office. It
supports very well "Microsoft PowerPoint" to PDF. "Microsoft Word"
can also be converted but some Word features are not supported
such as sections.
}
\section{Ubuntu platforms}{

On some Ubuntu platforms, 'LibreOffice' require to add in
the environment variable \code{LD_LIBRARY_PATH} the following path:
\verb{/usr/lib/libreoffice/program} (you should see the message
"libreglo.so cannot open shared object file" if it is the case). This
can be done with R
command \code{Sys.setenv(LD_LIBRARY_PATH = "/usr/lib/libreoffice/program/")}
}

\examples{
library(locatexec)
if (exec_available("libreoffice") && check_libreoffice_export()) {

  out_pptx <- tempfile(fileext = ".pdf")
  file <- system.file(package = "doconv",
    "doc-examples/example.pptx")

  to_pdf(input = file, output = out_pptx)

  out_docx <- tempfile(fileext = ".pdf")
  file <- system.file(package = "doconv",
    "doc-examples/example.docx")

  to_pdf(input = file, output = out_docx)

}
}
