% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dodgr-streetnet.R
\name{dodgr_streetnet_sc}
\alias{dodgr_streetnet_sc}
\title{dodgr_streetnet_sc}
\usage{
dodgr_streetnet_sc(bbox, pts = NULL, expand = 0.05, quiet = TRUE)
}
\arguments{
\item{bbox}{Bounding box as vector or matrix of coordinates, or location
name. Passed to \code{osmdata::getbb}.}

\item{pts}{List of points presumably containing spatial coordinates}

\item{expand}{Relative factor by which street network should extend beyond
limits defined by pts (only if \code{bbox} not given).}

\item{quiet}{If \code{FALSE}, display progress messages}
}
\value{
A Simple Features (\code{sf}) object with coordinates of all lines in
the street network.
}
\description{
Use the \code{osmdata} package to extract the street network for a given
location and return it in \code{SC}-format. For routing between a given set of
points (passed as \code{pts}), the \code{bbox} argument may be omitted, in which case a
bounding box will be constructed by expanding the range of \code{pts} by the
relative amount of \code{expand}.
}
\examples{
\dontrun{
streetnet <- dodgr_streetnet ("hampi india", expand = 0)
# convert to form needed for `dodgr` functions:
graph <- weight_streetnet (streetnet)
nrow (graph) # around 5,900 edges
# Alternative ways of extracting street networks by using a small selection of
# graph vertices to define bounding box:
verts <- dodgr_vertices (graph)
verts <- verts [sample (nrow (verts), size = 200), ]
streetnet <- dodgr_streetnet (pts = verts, expand = 0)
graph <- weight_streetnet (streetnet)
nrow (graph)
# This will generally have many more rows because most street networks include
# streets that extend considerably beyond the specified bounding box.

# bbox can also be a polygon:
bb <- osmdata::getbb ("gent belgium") # rectangular bbox
nrow (dodgr_streetnet (bbox = bb)) # around 30,000
bb <- osmdata::getbb ("gent belgium", format_out = "polygon")
nrow (dodgr_streetnet (bbox = bb)) # around 17,000
# The latter has fewer rows because only edges within polygon are returned
}
}
