% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmWithCov.r
\name{mlmWithCov}
\alias{mlmWithCov}
\title{Uses covariance/correlation matrix to calculate multivariate index of fit}
\usage{
mlmWithCov(f, x)
}
\arguments{
\item{f}{formula. Should use \code{cbind(y1,y2,...,yk)~x1+x2+..+xp}}

\item{x}{correlation/covariance matrix}
}
\value{
\item{r.squared.xy}{\eqn{R^2_{XY}} of the regression}
\item{p.squared.yx}{\eqn{P^2_{YX}} of the regression}
\item{formula}{formula provided as parameter}
\item{cov}{covariance/correlation matrix provided as parameter}
}
\description{
Calculate \eqn{R^2_{XY}} and  \eqn{P^2_{YX}} for multivariate regression
Could be used with \code{\link{dominanceAnalysis}} to
perform a multivariate dominance analysis without original
data.
}
\examples{
library(car)
library(heplots)
cor.m<-cor(Rohwer[Rohwer[,1]==1,2+c(7,8,1,2,3)])
lwith<-mlmWithCov(cbind(na,ss)~SAT+PPVT+Raven,cor.m)
da<-dominanceAnalysis(lwith)
print(da)
summary(da)
}
