% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{generate.remi}
\alias{generate.remi}
\title{Generation of the first order differential equation solution}
\usage{
generate.remi(dampingtime, inputvec, inputtim)
}
\arguments{
\item{dampingtime}{Signal damping time. It represents the characteristic response time of the solution of the differential equation.
It should be positive.}

\item{inputvec}{Is a vector containing the values of the excitation signal.}

\item{inputtim}{Is a vector containing the time values corresponding to the excitation signal.}
}
\value{
Returns a list containing two elements:
\itemize{
  \item  y is a vector containing the values calculated from the convolution of the Green function and the excitation vector.
  \item  t is a vector containing the corresponding time values
}
}
\description{
\code{generate.remi} returns a vector containing the convolution of the Green function
of the first order differential equation with a given damping time and an excitation term.
}
\examples{
generate.remi(10,rep(c(0,1,0),c(20,30,50)),1:100)
}
\keyword{Green,}
\keyword{differential}
\keyword{equation}
\keyword{excitation,}
\keyword{first}
\keyword{order}
