% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{hamling}
\alias{hamling}
\title{Approximating effective-counts as proposed by Hamling}
\usage{
hamling(y, v, cases, n, type, data)
}
\arguments{
\item{y}{a vector, defining the (reported) log relative risks.}

\item{v}{a vector, defining the variances of the reported log relative risks.}

\item{cases}{a vector, defining the number of cases for each exposure level.}

\item{n}{a vector, defining the total number of subjects for each exposure level. For incidence-rate data \code{n} indicates the amount of person-time within 
each exposure level.}

\item{type}{a vector (or a character string), specifying the design of the study. Options are
\code{cc}, \code{ir}, and \code{ci}, for case-control, incidence-rate, and cumulative incidence data, respectively.}

\item{data}{an optional data frame (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the previous arguments.}
}
\value{
A list containing the following
\tabular{ll}{
\code{y} \tab mean or standardized mean differences for each treatment level,
included the referent one (0 by calculation).\cr
\code{v} \tab variances corresponding to the mean or standardized mean differences for each 
treatment level, included the referent one (0 by calculation)\cr
\code{S} \tab co(variance) matrix for the non-referent mean or standardized mean differences.\cr
}
}
\description{
Reconstructs the set of pseudo-numbers (or "effective" numbers) of cases and non-cases consistent
with the input data (log relative risks). The method was first proposed in 2008 by Hamling.
}
\details{
The function reconstructs the effective counts corresponding to the multivariable adjusted log relative risks as well as their standard errors. 
A unique solution is guaranteed by keeping the ratio non-cases to cases and the fraction of unexposed subjects equal to the unadjusted data (Hamling). 
See the referenced article for a complete description of the algorithm implementation.
}
\examples{
## Loading data
data("alcohol_cvd")

## Obtaining pseudo-counts for the first study (id = 1)
hamling(y = logrr, v = I(se^2), cases = cases, n = n, type = type, 
data = subset(alcohol_cvd, id == 1))
   
## Obtaining pseudo-counts for all study
by(alcohol_cvd, alcohol_cvd$id, function(x)
hamling(y = logrr, v = I(se^2), cases = cases, n = n, type = type, data = x))

## Restructuring the previous results in a matrix
do.call("rbind", by(alcohol_cvd, alcohol_cvd$id, function(x)
   hamling(y = logrr, v = I(se^2), cases = cases, n = n, type = type,
      data = x)))
 
}
\references{
Hamling, J., Lee, P., Weitkunat, R., Ambuhl, M. (2008). Facilitating meta-analyses by deriving relative effect and precision estimates for alternative 
comparisons from a set of estimates presented by exposure level or disease category. Statistics in medicine, 27(7), 954-970.

Orsini, N., Li, R., Wolk, A., Khudyakov, P., Spiegelman, D. (2012). Meta-analysis for linear and nonlinear dose-response relations: examples, an evaluation 
of approximations, and software. American journal of epidemiology, 175(1), 66-73.
}
\seealso{
\code{\link{covar.logrr}}, \code{\link{grl}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
