% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_dc.R
\name{vector_dc}
\alias{vector_dc}
\alias{numeric_dc}
\alias{integer_dc}
\title{Allocate vectors in .C64()}
\usage{
vector_dc(mode = "logical", length = 0L)

numeric_dc(length = 0)

integer_dc(length = 0)
}
\arguments{
\item{mode}{Character vector of length 1. Storage mode of the vector to allocate.}

\item{length}{Numeric vector of length 1. Length of the vector to allocate.}
}
\value{
Object of class \code{vector_dc} and \code{list}.
}
\description{
Helper functions to be used in calls to \code{\link{.C64}}.
The function \code{vector_dc} and its shortcuts \code{numeric_dc} and
\code{integer_dc} return a R object of class \code{c("vector_dc", "list")}
containing the necessary information (type and length) to allocate the
vector (initialized with 0) inside the call to \code{\link{.C64}}.
Using \code{vector_dc} together with \code{INTENT = "w"} argument of \code{\link{.C64}}
leads to performance gains by avoiding unnecessary castings and copies.
}
\examples{
vector_dc("integer", 20)
}
