% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downlit-html.R
\name{downlit_html_path}
\alias{downlit_html_path}
\alias{downlit_html_node}
\title{Syntax highlight and link an HTML page}
\usage{
downlit_html_path(in_path, out_path)

downlit_html_node(x)
}
\arguments{
\item{in_path, out_path}{Input and output paths for HTML file}

\item{x}{An \code{xml2::xml_node}}
}
\value{
\code{downlit_html_path()} invisibly returns \code{output_path};
\code{downlit_html_node()} modifies \code{x} in place and returns nothing.
}
\description{
\itemize{
\item Code blocks, identified by \verb{<pre>} tags with class \code{sourceCode} and \code{r},
processed with \code{\link[=highlight]{highlight()}}.
\item Inline code, identified by \verb{<code>} tags that contain only text
(and don't have a header tag (e.g. \verb{<h1>}) or \verb{<a>} as an ancestor)
are processed processed with \code{\link[=autolink]{autolink()}}.
}

Use \code{downlit_html_path()} to process an \code{.html} file on disk;
use \code{downlit_html_node()} to process an in-memory \code{xml_node} as part of a
larger pipeline.
}
\examples{
node <- xml2::read_xml("<p><code>base::t()</code></p>")
node

# node is modified in place
downlit_html_node(node)
node
}
