% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Germlines.R
\name{stitchVDJ}
\alias{stitchVDJ}
\title{\link{stitchVDJ} combines germline gene segments to a single string}
\usage{
stitchVDJ(
  receptor,
  v_seq,
  d_seq,
  j_seq,
  np1_length = "np1_length",
  np2_length = "np2_length",
  np1_aa_length = "np1_aa_length",
  np2_aa_length = "np2_aa_length",
  amino_acid = FALSE
)
}
\arguments{
\item{receptor}{row from AIRR-table containing sequence of interest}

\item{v_seq}{germline V segment sequence from \link{getGermline}}

\item{d_seq}{germline D segment sequence from \link{getGermline}}

\item{j_seq}{germline J segment sequence from \link{getGermline}}

\item{np1_length}{Column name in receptor specifying np1 segment length 
(e.g. np1_length)}

\item{np2_length}{Column name in receptor specifying np2 segment length 
(e.g. np1_length)}

\item{np1_aa_length}{Column name in receptor specifying np1 segment length 
in AA (if amino_acid=TRUE, e.g. np1_length)}

\item{np2_aa_length}{Column name in receptor specifying np2 segment length 
in AA (if amino_acid=TRUE, e.g. np1_length)}

\item{amino_acid}{Perform reconstruction on amino acid sequence (experimental)}
}
\value{
Full length germline VDJ sequence aligned with aligned with the 
sequence in the \code{seq} column of \code{receptor}.
}
\description{
\link{stitchVDJ} combines germline gene segments to a single string
}
