library(shiny)
library(shinythemes)

shinyUI(navbarPage(title = "dpcReport",
                   theme = shinytheme("cerulean"),
                   id = "navbar", windowTitle = "dpcReport", collapsible=TRUE,
                   tabPanel("Input file",
                            includeMarkdown("input_file1.md"),
                            fluidRow(
                              column(2, fileInput("input_file", 
                                                  h4("Choose dPCR data"))),
                              column(2, selectInput("input_type", label = h4("Select data format"), 
                                                    choices = list("Raw data (adpcr)" = "raw_adpcr", 
                                                                   "Raw data (ddpcr)" = "raw_ddpcr",
                                                                   "QX100" = "QX100",
                                                                   "BioMark (Detailed Table Results)" = "BioMark_det",
                                                                   "BioMark (Summary Table Results)" = "BioMark_sum"))),
                              column(3, htmlOutput("input_information"))
                            ),
                            includeMarkdown("input_file2.md"),
                            fluidRow(
                              column(3, h4("Experiment name"), htmlOutput("exp_choice")),
                              column(3, h4("Technical repeat ID"), htmlOutput("rep_choice"))
                            )
                   ),
                   navbarMenu("Data summary",
                              tabPanel("Summary table", 
                                       DT::dataTableOutput("summary_input"),
#                                        downloadButton("summary_table_download_button", 
#                                                       "Save table (.csv)"),
                                       includeMarkdown("./data_summary/data_summary_table1.md")),
                              #summary boxplot and stripchart
                              tabPanel("Summary charts", 
                                       includeMarkdown("./summary_plots/data_summary_scatterchart1.md"),
                                       plotOutput("summary_plot", 
                                                  dblclick = dblclickOpts(id = "summary_plot_dbl")),
                                       fluidRow(
                                         column(3, downloadButton("summary_plot_download_button", 
                                                                  "Save chart (.svg)")),
                                         column(3, actionButton("summary_plot_reset", 
                                                                "Reset chart"))
                                         ),
                                       br(),
                                       htmlOutput("summary_plot_dbl"),
                                       includeMarkdown("./summary_plots/data_summary_scatterchart2.md"),
                                       selectInput("CI_method", label = h4("Select method for CI calculation:"), 
                                                   choices = list("Dube" = "dube", "Bhat" = "bhat")),
                                       htmlOutput("summary_exprep_plot_ui"),
                                       fluidRow(
                                         column(3, downloadButton("summary_exprep_plot_download_button", 
                                                      "Save chart (.svg)")),
                                         column(3, actionButton("summary_exprep_plot_reset", 
                                                                "Reset chart"))
                                         ),
                                       htmlOutput("summary_exprep_plot_dbl"))),
                   #test counts
                   tabPanel("Comparison of runs", 
                            includeMarkdown("./test_counts/test_counts1.md"),
                            DT::dataTableOutput("test_counts_res"),
#                             downloadButton("test_counts_res_download_button", 
#                                            "Save table (.csv)"),
                            includeMarkdown("./test_counts/test_counts2.md"),
                            DT::dataTableOutput("test_counts_groups"),
#                             downloadButton("test_counts_groups_download_button", 
#                                            "Save table (.csv)"),
                            htmlOutput("test_counts_plot_ui"),
                            fluidRow(
                              column(3, downloadButton("test_counts_plot_download_button", 
                                                       "Save chart (.svg)")),
                              column(3, actionButton("test_counts_plot_reset", 
                                                     "Reset chart"))
                              ),
                            htmlOutput("test_count_dbl"),
                            includeMarkdown("./test_counts/test_counts3.md")),
                   navbarMenu("Advanced analysis",
                              tabPanel(title = "Array spatial analysis", 
                                       htmlOutput("plot_panel_tab")),
                              tabPanel(title = "Probability distribution", 
                                       includeMarkdown("./prob_distr/prob_distr1.md"),
                                       htmlOutput("run_choice"),
                                       includeMarkdown("./prob_distr/prob_distr2.md"),
                                       DT::dataTableOutput("moments_table"),
                                       # downloadButton("moments_table_download_button", "Save table (.csv)"),
                                       includeMarkdown("./prob_distr/prob_distr3.md"),
                                       fluidRow(
                                         column(3, selectInput("density_plot_avg", label = h4("Select parameter:"), 
                                                               choices = c("k" = FALSE, "lambda" = TRUE))),
                                         
                                         column(3, selectInput("density_plot_methods", h4("Choose method of calculating CI:"), 
                                                               choices  = list("Agresti-Coull" = "agresti-coull", 
                                                                               "Asymptotic" = "asymptotic", 
                                                                               "Bayesian inference"  = "bayes", 
                                                                               "Cloglog parameterization" = "cloglog", 
                                                                               "Logit parameterization" = "logit", 
                                                                               "Pearson-Klopper" = "exact", 
                                                                               "Probit parameterization" = "probit",
                                                                               "Proportion test" = "prop.test", 
                                                                               "Wilson" = "wilson"), 
                                                               "wilson")),
                                         column(3, numericInput("density_plot_cil", h4("Confidence intervals level:"), 
                                                                0.95, min = 0, max = 1,
                                                                step = 0.01)),
                                         column(3, selectInput("density_plot_bars", label = h4("Plot bars:"), 
                                                               choices = c("yes" = TRUE, "no" = FALSE)))
                                       ),
                                       plotOutput("density_plot"),
                                       downloadButton("density_plot_download_button", 
                                                      "Save chart (.svg)"),
                                       includeMarkdown("./prob_distr/prob_distr4.md")
                              )
                   ),
                   tabPanel("Save report",
                            includeMarkdown("download_report1.md"),
                            checkboxInput("data_summary_table_rep", "Data summary table", 
                                          value = TRUE),
                            checkboxInput("data_summary_scatter_rep", "Data summary scatter charts", 
                                          value = TRUE),
                            checkboxInput("data_summary_test_counts", "Compare runs", 
                                          value = TRUE),
                            checkboxInput("plot_panel", "Visualise and analyze individually each array", 
                                          value = FALSE),
                            checkboxInput("poisson_distr", "Visualise and analyze probability distribution of each run", 
                                          value = FALSE),
                            checkboxInput("R_code", "R code used in the report generation", 
                                          value = TRUE),
                            p("Be patient. The generation of the report may take few minutes."),
                            downloadButton("report_download_button", 
                                           "Save report")),
                   tabPanel("About", 
                            includeMarkdown("about.md")),
                   tabPanel("Quit", actionButton("quit_button", "Press the button to quit dpcReport"))
))
