% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpkg_release_gh.R
\name{use_dpkg_badge}
\alias{use_dpkg_badge}
\title{Use a markdown badge for a dpkg's latest github release}
\usage{
use_dpkg_badge(x)
}
\arguments{
\item{x}{a data package (\code{dpkg}) object}
}
\value{
character string of markdown
}
\description{
The badge relies on shields.io for the images, which will always
display to the most recently released version and will link to the
releases specific to the dpkg name.
}
\details{
Note that this relies on the structure of the release created with
\code{dpkg_gh_release()}, but relies on a dpkg object \emph{before} it is released.
This will lead to broken release badges and links until an initial
dpkg release is created with \code{dpkg_gh_release()}.
}
\examples{
\dontrun{
as_dpkg(mtcars,
  version = "0.0.0.9000", title = "Foofy Cars",
  homepage = "https://github.com/cole-brokamp/dpkg",
  description =
    paste("# Foofy Cars\n",
      "This is a test for the [dpkg](https://github.com/cole-brokamp/dpkg) package.",
      collapse = "\n"
    )
) |>
  use_dpkg_badge()
}

}
