% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/correlation_function.R
\name{correlation.function}
\alias{correlation.function}
\title{Performs correlations functions}
\usage{
correlation.function(climate.anom.season.data, site.chron.data, site.boot.data,
  period.RF, col.names.season, Climate.name, Subset.name)
}
\arguments{
\item{climate.anom.season.data}{climate data anomalies for seasons}

\item{site.chron.data}{site chronologies, matrix: rows=year, col=subset.1, subset.2,fullest}

\item{site.boot.data}{bootstrapped site chronologies, list: matrices for each subset    with: row=year, col=bootstrapped series}

\item{period.RF}{the period used to calculate response functions, vector: (start,end)}

\item{col.names.season}{col.names.season<- list("SON_2", "DJF_2", "MAM_2", "JJA_2", "SON_1", "DJF_1", "MAM_1", "JJA_1", "SON", "DJF", "MAM", "JJA")}

\item{Climate.name}{name of the climate variable for which correlation functions are being calculated}

\item{Subset.name}{names given to each of the subsets.}
}
\value{
\item{corr.site.1}{The correlations between the climate variable and the site chronology for the 1st subset.}
\item{corr.site.2}{The correlations between the climate variable and the site chronology for the 12st subset.}
\item{percentile.ci.1}{The percentile confidence intervals for the 1st subset.}
\item{percentile.ci.2}{The percentile confidence intervals for the 2st subset.}

Other summary varibles \item{summary.ci.1}{}\item{summary.ci.2}{}\item{t.mean}{Test for correlation equal zero}\item{t.meanequal}{Test for correlations from the two subsets are equal}\item{percentile.ci}{}
}
\description{
Uses the imported climate variables and tree ring data to produce seasonal correlation functions. Also, uses the bootstrapped chronologies to produce confidence intervals.
}
\note{
site.chron.data, and site.boot.data must be in the same order and confidence intervals plotted are for the 1st two subsets.
}
\examples{
\dontrun{
period.RF<-c(1900,1990)
col.names.season <- list("SON_2", "DJF_2", "MAM_2", "JJA_2", "SON_1", "DJF_1", "MAM_1","JJA_1",
         "SON", "DJF", "MAM", "JJA")
##  Full dataset
site.full <- site.chron(spline200.sub0.2000.n$sub.series.stand, aver.by.tree=F)
site.chron.data <- cbind(site.full$aver.site, site.full$aver.site)
site.boot.full <- ts(boot.full$boot.series.mean, start=tsp(site.full$aver.site)[1] )
site.boot.data<-list(site.boot.full, site.boot.full)

corr.SOI.full<-correlation.function(SOI.anom.season.data, site.chron.data,site.boot.data,
      period.RF, col.names.season,
      Climate.name="SOI", Subset.name=c("0-20cm","20-200cm" ) )
corr.prec.full<-correlation.function(prec.anom.season.data, site.chron.data,site.boot.data,
     period.RF, col.names.season,
     Climate.name="SOI", Subset.name=c("0-20cm","20-200cm" ) )
corr.temp.full<-correlation.function(temp.anom.season.data, site.chron.data,site.boot.data,
     period.RF, col.names.season,
     Climate.name="SOI", Subset.name=c("0-20cm","20-200cm" ) )

##	Near vs Far
site.0.20  <- site.chron(spline200.sub0.20.n$sub.series.stand, aver.by.tree=F)
site.20.200 <- site.chron(spline200.sub20.2000.n$sub.series.stand, aver.by.tree=F)
site.chron.data <- cbind(site.0.20$aver.site, site.20.200$aver.site)

site.boot.0.20 <- ts(boot.0.20$boot.series.mean, start=tsp(site.0.20$aver.site)[1] )
site.boot.20.200 <- ts(boot.20.2000$boot.series.mean, start=tsp(site.20.200$aver.site)[1] )
site.boot.data<-list(site.boot.0.20, site.boot.20.200)

corr.SOI<-correlation.function(SOI.anom.season.data, site.chron.data, site.boot.data,
   period.RF, col.names.season,
   Climate.name="SOI",Subset.name=c("0-20cm","20-200cm" ) )
corr.prec<-correlation.function(prec.anom.season.data, site.chron.data,          site.boot.data,
   period.RF, col.names.season,
   Climate.name="SOI", Subset.name=c("0-20cm","20-200cm" ) )
corr.temp<-correlation.function(temp.anom.season.data, site.chron.data, site.boot.data,
   period.RF, col.names.season,
   Climate.name="SOI", Subset.name=c("0-20cm","20-200cm" ) )
}
}

