% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dplyr-cluster}
\alias{dplyr-cluster}
\alias{get_cluster}
\alias{has_cluster}
\alias{init_cluster}
\alias{set_cluster}
\alias{stop_cluster}
\title{Cluster management.}
\usage{
set_cluster(x)

stop_cluster()

get_cluster()

has_cluster()

init_cluster(cores = NA, quiet = FALSE)
}
\description{
For parallel operations in \code{\link{do}}, dplyr maintains a light-weight
local cluster. Cluster creation is relatively expensive (around a second)
so the cluster is created once and cached for subsequent use.
}
\details{
On windows, this is a PSOCK cluster, and on linux/mac it's a fork cluster.
If not supplied, the number of cores will be two less than the number of
cores provided by \code{\link[parallel]{detectCores}}.

\code{get_cluster}, \code{set_cluster} and \code{has_cluster} are low
level accessor functions to control the cluster cache. You shouldn't
need to use these unless you want to create your own cluster using another
mechanism. \code{init_cluster} creates and caches a new cluster, and
\code{stop_cluster} shuts it down.
}
\keyword{internal}

