% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-equal.r
\name{all_equal}
\alias{all_equal}
\alias{all.equal.tbl_df}
\title{Flexible equality comparison for data frames}
\usage{
all_equal(target, current, ignore_col_order = TRUE, ignore_row_order = TRUE,
  convert = FALSE, ...)

\method{all.equal}{tbl_df}(target, current, ignore_col_order = TRUE,
  ignore_row_order = TRUE, convert = FALSE, ...)
}
\arguments{
\item{target, current}{Two data frames to compare.}

\item{ignore_col_order}{Should order of columns be ignored?}

\item{ignore_row_order}{Should order of rows be ignored?}

\item{convert}{Should similar classes be converted? Currently this will
convert factor to character and integer to double.}

\item{...}{Ignored. Needed for compatibility with \code{all.equal()}.}
}
\value{
\code{TRUE} if equal, otherwise a character vector describing
the reasons why they're not equal. Use \code{\link[=isTRUE]{isTRUE()}} if using the
result in an \code{if} expression.
}
\description{
You can use \code{all_equal()} with any data frame, and dplyr also provides
\code{tbl_df} methods for \code{\link[=all.equal]{all.equal()}}.
}
\examples{
scramble <- function(x) x[sample(nrow(x)), sample(ncol(x))]

# By default, ordering of rows and columns ignored
all_equal(mtcars, scramble(mtcars))

# But those can be overriden if desired
all_equal(mtcars, scramble(mtcars), ignore_col_order = FALSE)
all_equal(mtcars, scramble(mtcars), ignore_row_order = FALSE)

# By default all_equal is sensitive to variable differences
df1 <- data.frame(x = "a")
df2 <- data.frame(x = factor("a"))
all_equal(df1, df2)
# But you can request dplyr convert similar types
all_equal(df1, df2, convert = TRUE)
}
