% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_map.R
\name{group_map}
\alias{group_map}
\alias{group_walk}
\title{Apply a function to each group}
\usage{
group_map(.tbl, .f, ...)

group_walk(.tbl, .f, ...)
}
\arguments{
\item{.tbl}{A grouped tibble}

\item{.f}{A function or formula to apply to each group. It must return a data frame.

If a \strong{function}, it is used as is. It should have at least 2 formal arguments.

If a \strong{formula}, e.g. \code{~ head(.x)}, it is converted to a function.

In the formula, you can use
\itemize{
\item \code{.} or \code{.x} to refer to the subset of rows of \code{.tbl}
for the given group
\item \code{.y} to refer to the key, a one row tibble with one column per grouping variable
that identifies the group
}}

\item{...}{Additional arguments passed on to \code{.f}}
}
\value{
\itemize{
\item \code{group_map()} row binds the data frames returned by \code{.f}
\item \code{group_walk()} calls \code{.f} for side effects and returns the input \code{.tbl}, invisibly
}
}
\description{
\code{group_map()} and \code{group_walk()} are purrr-style functions that can
be used to iterate on grouped tibbles.
}
\details{
\Sexpr[results=rd, stage=render]{dplyr:::lifecycle("experimental")}
\itemize{
\item Use \code{group_map()} when \code{summarize()} is too limited, in terms of what you need
to do and return for each group. \code{group_map()} is good for "data frame in, data frame out".
If that is too limited, you need to use a \link[=group_nest]{nested} or \link[=group_split]{split} workflow.
\item \code{group_map()} and \code{group_walk()} are an evolution of \code{\link[=do]{do()}}, if you have used that before.
}

Each conceptual group of the data frame is exposed to the function \code{.f} with two pieces of information:
\itemize{
\item The subset of the data for the group, exposed as \code{.x}.
\item The key, a tibble with exactly one row and columns for each grouping variable, exposed as \code{.y}.
}

\code{.f} must return a data frame that does not contain any of the grouping variables of \code{.tbl}.

For completeness, \code{group_map()} and \code{group_walk()} also work on
ungrouped data frames, in that case the function is applied to the
entire data frame (exposed as \code{.x}), and \code{.y} is a one row tibble with no
column, consistently with \code{\link[=group_keys]{group_keys()}}.
}
\examples{
mtcars \%>\%
  group_by(cyl) \%>\%
  group_map(~ head(.x, 2L))

if (requireNamespace("broom", quietly = TRUE)) {
  iris \%>\%
    group_by(Species) \%>\%
    group_map(~ broom::tidy(lm(Petal.Length ~ Sepal.Length, data = .x)))
}

iris \%>\%
  group_by(Species) \%>\%
  group_map(~ {
     quantile(.x$Petal.Length, probs = c(0.25, 0.5, 0.75)) \%>\%
     tibble::enframe(name = "prob", value = "quantile")
  })

iris \%>\%
  group_by(Species) \%>\%
  group_map(~ {
    .x \%>\%
      purrr::map_dfc(fivenum) \%>\%
      mutate(nms = c("min", "Q1", "median", "Q3", "max"))
  })

# group_walk() is for side effects
dir.create(temp <- tempfile())
iris \%>\%
  group_by(Species) \%>\%
  group_walk(~ write.csv(.x, file = file.path(temp, paste0(.y$Species, ".csv"))))
list.files(temp, pattern = "csv$")
unlink(temp, recursive = TRUE)

# group_map() and ungrouped data frames
mtcars \%>\%
  group_map(~ head(.x, 2L))

}
\seealso{
Other grouping functions: \code{\link{group_by_all}},
  \code{\link{group_by}}, \code{\link{group_indices}},
  \code{\link{group_keys}}, \code{\link{group_nest}},
  \code{\link{group_rows}}, \code{\link{group_size}},
  \code{\link{group_trim}}, \code{\link{groups}}
}
\concept{grouping functions}
