% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_trim.R
\name{group_trim}
\alias{group_trim}
\title{Trim grouping structure}
\usage{
group_trim(.tbl, .drop = group_drops(.tbl))
}
\arguments{
\item{.tbl}{A \link[=grouped_df]{grouped data frame}}

\item{.drop}{See \code{\link[=group_by]{group_by()}}}
}
\value{
A \link[=grouped_df]{grouped data frame}
}
\description{
Drop unused levels of all factors that are used as grouping variables,
then recalculates the grouping structure.

\code{group_trim()} is particularly useful after a \code{\link[=filter]{filter()}} that is intended
to select a subset of groups.
}
\details{
\Sexpr[results=rd, stage=render]{dplyr:::lifecycle("experimental")}
}
\examples{
iris \%>\%
  group_by(Species) \%>\%
  filter(Species == "setosa", .preserve = TRUE) \%>\%
  group_trim()

}
\seealso{
Other grouping functions: \code{\link{group_by_all}},
  \code{\link{group_by}}, \code{\link{group_indices}},
  \code{\link{group_keys}}, \code{\link{group_map}},
  \code{\link{group_nest}}, \code{\link{group_rows}},
  \code{\link{group_size}}, \code{\link{groups}}
}
\concept{grouping functions}
