% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-do.r
\name{do}
\alias{do}
\title{Do anything}
\usage{
do(.data, ...)
}
\arguments{
\item{.data}{a tbl}

\item{...}{Expressions to apply to each group. If named, results will be
stored in a new column. If unnamed, should return a data frame. You can
use \code{.} to refer to the current group. You can not mix named and
unnamed arguments.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("superseded")}

\code{do()} is superseded as of dplyr 1.0.0, because its syntax never really
felt like it belong with the rest of dplyr. It's replaced by a combination
of \code{\link[=summarise]{summarise()}} (which can now produce multiple rows and multiple columns),
\code{\link[=nest_by]{nest_by()}} (which creates a \link{rowwise} tibble of nested data),
and \code{\link[=across]{across()}} (which allows you to access the data for the "current" group).
}
\examples{
# do() with unnamed arguments becomes summarise()
# . becomes across()
by_cyl <- mtcars \%>\% group_by(cyl)
by_cyl \%>\% do(head(., 2))
# ->
by_cyl \%>\% summarise(head(across(), 2))
by_cyl \%>\% slice_head(n = 2)

# Can refer to variables directly
by_cyl \%>\% do(mean = mean(.$vs))
# ->
by_cyl \%>\% summarise(mean = mean(vs))

# do() with named arguments becomes nest_by() + mutate() & list()
models <- by_cyl \%>\% do(mod = lm(mpg ~ disp, data = .))
# ->
models <- mtcars \%>\%
  nest_by(cyl) \%>\%
  mutate(mod = list(lm(mpg ~ disp, data = data)))
models \%>\% summarise(rsq = summary(mod)$r.squared)

# use broom to turn models into data
models \%>\% do(data.frame(
  var = names(coef(.$mod)),
  coef(summary(.$mod)))
)
# ->
if (requireNamespace("broom")) {
  models \%>\% summarise(broom::tidy(mod))
}
}
\keyword{internal}
