% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.r
\name{nest_join}
\alias{nest_join}
\alias{nest_join.data.frame}
\title{Nest join}
\usage{
nest_join(x, y, by = NULL, copy = FALSE, keep = FALSE, name = NULL, ...)

\method{nest_join}{data.frame}(x, y, by = NULL, copy = FALSE, keep = FALSE, name = NULL, ...)
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A character vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so that you
can check they're correct; suppress the message by supplying \code{by} explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with length > 1.
For example, \code{by = c("a", "b")} will match \code{x$a} to \code{y$a} and \code{x$b} to
\code{y$b}. Use a named vector to match different variables in \code{x} and \code{y}.
For example, \code{by = c("a" = "b", "c" = "d")} will match \code{x$a} to \code{y$b} and
\code{x$c} to \code{y$d}.

To perform a cross-join, generating all combinations of \code{x} and \code{y},
use \code{by = character()}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the
output? Only applies to \code{nest_join()}, \code{left_join()}, \code{right_join()}, and
\code{full_join()}.}

\item{name}{The name of the list column nesting joins create.
If \code{NULL} the name of \code{y} is used.}

\item{...}{Other parameters passed onto methods.}
}
\description{
\code{nest_join()} returns all rows and columns in \code{x} with a new nested-df column
that contains all matches from \code{y}. When there is no match, the list column
is a 0-row tibble.
}
\details{
In some sense, a \code{nest_join()} is the most fundamental join since you can
recreate the other joins from it:
\itemize{
\item \code{inner_join()} is a \code{nest_join()} plus \code{\link[tidyr:unnest]{tidyr::unnest()}}
\item \code{left_join()} \code{nest_join()} plus \code{unnest(.drop = FALSE)}.
\item \code{semi_join()} is a \code{nest_join()} plus a \code{filter()} where you check
that every element of data has at least one row,
\item \code{anti_join()} is a \code{nest_join()} plus a \code{filter()} where you check every
element has zero rows.
}
}
\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("nest_join")}.
}

\examples{
band_members \%>\% nest_join(band_instruments)
}
\seealso{
Other joins: 
\code{\link{filter-joins}},
\code{\link{mutate-joins}}
}
\concept{joins}
