% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-group-by.R
\name{group_by_all}
\alias{group_by_all}
\alias{group_by_at}
\alias{group_by_if}
\title{Group by a selection of variables}
\usage{
group_by_all(
  .tbl,
  .funs = list(),
  ...,
  .add = FALSE,
  .drop = group_by_drop_default(.tbl)
)

group_by_at(
  .tbl,
  .vars,
  .funs = list(),
  ...,
  .add = FALSE,
  .drop = group_by_drop_default(.tbl)
)

group_by_if(
  .tbl,
  .predicate,
  .funs = list(),
  ...,
  .add = FALSE,
  .drop = group_by_drop_default(.tbl)
)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A function \code{fun}, a quosure style lambda \code{~ fun(.)} or a list of either form.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:dyn-dots]{tidy dots} support.}

\item{.add}{See \code{\link[=group_by]{group_by()}}}

\item{.drop}{Drop groups formed by factor levels that don't appear in the
data? The default is \code{TRUE} except when \code{.data} has been previously
grouped with \code{.drop = FALSE}. See \code{\link[=group_by_drop_default]{group_by_drop_default()}} for details.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Scoped verbs (\verb{_if}, \verb{_at}, \verb{_all}) have been superseded by the use of
\code{\link[=pick]{pick()}} or \code{\link[=across]{across()}} in an existing verb. See \code{vignette("colwise")} for
details.

These \link{scoped} variants of \code{\link[=group_by]{group_by()}} group a data frame by a
selection of variables. Like \code{\link[=group_by]{group_by()}}, they have optional
\link{mutate} semantics.
}
\section{Grouping variables}{


Existing grouping variables are maintained, even if not included in
the selection.
}

\examples{
# Group a data frame by all variables:
group_by_all(mtcars)
# ->
mtcars \%>\% group_by(pick(everything()))

# Group by variables selected with a predicate:
group_by_if(iris, is.factor)
# ->
iris \%>\% group_by(pick(where(is.factor)))

# Group by variables selected by name:
group_by_at(mtcars, vars(vs, am))
# ->
mtcars \%>\% group_by(pick(vs, am))

# Like group_by(), the scoped variants have optional mutate
# semantics. This provide a shortcut for group_by() + mutate():
d <- tibble(x=c(1,1,2,2), y=c(1,2,1,2))
group_by_all(d, as.factor)
# ->
d \%>\% group_by(across(everything(), as.factor))

group_by_if(iris, is.factor, as.character)
# ->
iris \%>\% group_by(across(where(is.factor), as.character))
}
\keyword{internal}
