% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hot_helpers.R
\name{dq_hot_cell}
\alias{dq_hot_cell}
\title{Configure individual cells of rhandsontable widget}
\usage{
dq_hot_cell(hot, row, col, ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{row}{integer vector specifying the rows to configure}

\item{col}{integer vector specifying the columns to configure}

\item{...}{parameters to be set in the cells, can be all rhandsontable
parameters and additional custom ones used with custom renderers or editors}
}
\description{
Configure individual cells of a rhandsontable widget. Can be
used just like \code{\link[rhandsontable:hot_cols]{hot_cols}} or
\code{\link[rhandsontable:hot_col]{hot_col}} to specify custom options or
cells. All possible combinations of row and column indices will be set.
}
\examples{
df <- data.frame(readOrWrite = rep(c("readOnly", "change me!"), 5),
  secret = rep("tops3cr3t", 10), stringsAsFactors = FALSE)

hot <- rhandsontable::rhandsontable(df, rowHeaders = NULL)
hot <- dq_hot_cell(hot, seq(1, 10, 2), 1:2, readOnly = TRUE)
hot <- dq_hot_cell(hot, seq(1, 10, 2), 2, type = "password")
hot
}
\author{
richard.kunze
}
