% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lum_export.R
\name{lum_export}
\alias{lum_export}
\title{Extract and generates data.frame from lum_import object}
\usage{
lum_export(x, y = NULL, path = NULL, backname = "ackgro",
    stanname = "tandar", samplename = "Sample",
    dilutionname = "Dilution Factor", batchname = "batch", ...)
}
\arguments{
\item{x}{a \code{lum_import} object with all information of the
xPONENT software imported}

\item{y}{an optional \code{lum_import} object different from \code{x}}

\item{path}{the directory name where all files are exported. The directory
is created according to batch name and system date. Default is \code{NULL}}

\item{backname}{character vector that defines background}

\item{stanname}{character vector that defines standard}

\item{samplename}{character vector that defines the name of the samples
variable}

\item{dilutionname}{character vector that defines the name of the dilution
factor variable}

\item{batchname}{character vector that defines the name of the batch field
in CSV}

\item{...}{other parameters of the function}
}
\description{
Extract, generates and export different information from a lum_import object
}
\details{
This function returns a list with all datasets from an object of
class \code{lum_import}. Also is possible to export into several csv files
(for Fluorescence-type data) or zip file (for Bead-type data).
}
\examples{
# Read all data
imp_path <-  system.file(c("inst","extdata"),"plate1.csv",
package="drLumi")
imp <- lum_import(imp_path)
exp <- lum_export(imp)
names(exp)

# See variables
imp$well_vars

# Select only 2
imp$well_vars <- c("Median", "Net MFI")
exp <- lum_export(imp)
head(exp$well)
}

