% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{readd}
\alias{readd}
\title{Function \code{readd}}
\usage{
readd(x, character_only = FALSE, path = getwd(), search = FALSE,
  envir = parent.frame())
}
\arguments{
\item{x}{If \code{character_only} is \code{TRUE}, 
\code{x} is a character variable storing the name of the item to get 
from the cache. Otherwise, \code{x} is a symbol with the literal 
object name.}

\item{character_only}{\code{TRUE}/\code{FALSE}, whether \code{x} 
can be assumed to be a character string 
(just as in \code{\link{library}()}).}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{envir}{environment of imported functions (for lexical scoping)}
}
\value{
drake output item from the cache
}
\description{
Read a drake output object from the cache.
Does not delete the item from the cache.
}
\seealso{
\code{\link{loadd}}, \code{\link{cached}}, 
\code{\link{built}}, \code{link{imported}}, \code{\link{plan}}, 
\code{\link{make}}, \code{\link{help_drake}}
}

