% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\title{Function config}
\usage{
config(plan, targets = drake::possible_targets(plan),
  envir = parent.frame(), verbose = TRUE,
  parallelism = drake::default_parallelism(), jobs = 1,
  packages = (.packages()), prework = character(0))
}
\arguments{
\item{plan}{same as for \code{\link{make}}}

\item{targets}{same as for \code{\link{make}}}

\item{envir}{same as for \code{\link{make}}}

\item{verbose}{same as for \code{\link{make}}}

\item{parallelism}{same as for \code{\link{make}}}

\item{jobs}{same as for \code{\link{make}}}

\item{packages}{same as for \code{\link{make}}}

\item{prework}{same as for \code{\link{make}}}
}
\description{
Compute the internal runtime parameter list of 
\code{\link{make}()}. This could save time if you are planning
multiple function calls of functions like \code{\link{outdated}()}
or \code{\link{plot_graph}()}. Drake needs to import and cache files 
and objects to compute the configuration list, which in turn 
supports user-side functions to help with visualization and parallelism.
The result differs from 
\code{\link{make}(..., imports_only = TRUE, return_config = TRUE)}
in that the graph includes both the targets and the imports,
not just the imports.
}
\examples{
\dontrun{
load_basic_example()
con = config(my_plan)
outdated(my_plan, config = con)
missed(my_plan, config = con)
max_useful_jobs(my_plan, config = con)
plot_graph(my_plan, config = con)
dataframes_graph(my_plan, config = con)
}
}
\seealso{
\code{\link{plan}}, \code{\link{make}}, \code{\link{plot_graph}}
}
