% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readd}
\alias{readd}
\title{Function \code{readd}}
\usage{
readd(target, character_only = FALSE, path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search))
}
\arguments{
\item{target}{If \code{character_only} is \code{TRUE},
\code{target} is a character string naming the object to read.
Otherwise, \code{target} is an unquoted symbol with the name of the
object. Note: \code{target} could be the name of an imported object.}

\item{character_only}{logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link{library}()}).}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}
}
\value{
drake target item from the cache
}
\description{
Read a drake target object from the cache.
Does not delete the item from the cache.
}
\examples{
\dontrun{
load_basic_example()
make(my_plan)
readd(reg1)
readd(small)
readd("large", character_only = TRUE)
readd("'report.md'") # just a fingerprint of the file (md5 sum)
}
}
\seealso{
\code{\link{loadd}}, \code{\link{cached}},
\code{\link{built}}, \code{link{imported}}, \code{\link{plan}},
\code{\link{make}}
}
