% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{dependency_profile}
\alias{dependency_profile}
\title{Return the detailed dependency profile
of the target.}
\usage{
dependency_profile(target, config = drake::read_drake_config())
}
\arguments{
\item{target}{name of the target}

\item{config}{configuration list output by
\code{\link[=config]{config()}} or \code{\link[=make]{make()}}}
}
\value{
A list of information that drake takes into account
when examining the dependencies of the target.
}
\description{
Useful for debugging.
For up to date targets, like elements
of the returned list should agree: for example,
\code{cached_dependency_hash} and
\code{current_dependency_hash}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Load drake's canonical example.
con <- make(my_plan) # Run the project, build the targets.
# Get some example dependency profiles of targets.
dependency_profile("small", config = con)
dependency_profile(file_store("report.md"), config = con)
})
}
}
\seealso{
\code{\link[=read_drake_meta]{read_drake_meta()}},
\code{\link[=deps_code]{deps_code()}}, \code{\link[=make]{make()}},
\code{\link[=config]{config()}}
}
