% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{drake_unquote}
\alias{drake_unquote}
\title{Remove leading and trailing
escaped quotes from character strings.}
\usage{
drake_unquote(x = NULL, deep = FALSE)
}
\arguments{
\item{x}{character vector}

\item{deep}{deprecated logical.}
}
\value{
Character vector without leading
or trailing escaped quotes around
the elements.
}
\description{
Quotes are important in drake.
In workflow plan data frame commands,
single-quoted targets denote physical files,
and double-quoted strings are treated as ordinary string literals.
}
\examples{
x <- "'abcd'"
# Remove the literal quotes around x.
drake_unquote(x) # "abcd"
}
\seealso{
\code{\link[=drake_quotes]{drake_quotes()}}, \code{\link[=drake_strings]{drake_strings()}}
}
