% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-cache.R
\name{new_cache}
\alias{new_cache}
\title{Make a new \code{drake} cache.}
\usage{
new_cache(path = NULL, verbose = 1L, type = NULL,
  hash_algorithm = NULL, short_hash_algo = NULL,
  long_hash_algo = NULL, ..., console_log_file = NULL)
}
\arguments{
\item{path}{File path to the cache if the cache
is a file system cache.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{type}{Deprecated argument. Once stood for cache type.
Use \code{storr} to customize your caches instead.}

\item{hash_algorithm}{Name of a hash algorithm to use.
See the \code{algo} argument of the \code{digest} package for your options.}

\item{short_hash_algo}{Deprecated on 2018-12-12. Use \code{hash_algorithm} instead.}

\item{long_hash_algo}{Deprecated on 2018-12-12. Use \code{hash_algorithm} instead.}

\item{...}{other arguments to the cache constructor.}

\item{console_log_file}{Character scalar,
connection object (such as \code{stdout()}) or \code{NULL}.
If \code{NULL}, console output will be printed
to the R console using \code{message()}.
If a character scalar, \code{console_log_file}
should be the name of a flat file, and
console output will be appended to that file.
If a connection object (e.g. \code{stdout()})
warnings and messages will be sent to the connection.
For example, if \code{console_log_file} is \code{stdout()},
warnings and messages are printed to the console in real time
(in addition to the usual in-bulk printing
after each target finishes).}
}
\value{
A newly created drake cache as a storr object.
}
\description{
Uses the \code{\link[=storr_rds]{storr_rds()}} function
from the \code{storr} package.
}
\examples{
\dontrun{
test_with_dir("Quarantine new_cache() side effects.", {
clean(destroy = TRUE) # Should not be necessary.
unlink("not_hidden", recursive = TRUE) # Should not be necessary.
cache1 <- new_cache() # Creates a new hidden '.drake' folder.
cache2 <- new_cache(path = "not_hidden", hash_algorithm = "md5")
clean(destroy = TRUE, cache = cache2)
})
}
}
\seealso{
\code{\link[=make]{make()}}
}
