% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{progress}
\alias{progress}
\title{Get the build progress of your targets
\lifecycle{maturing}}
\usage{
progress(..., list = character(0), no_imported_objects = NULL,
  path = NULL, search = NULL, cache = drake::drake_cache(path =
  path), verbose = 1L, jobs = 1, progress = NULL)
}
\arguments{
\item{...}{Objects to load from the cache, as names (unquoted)
or character strings (quoted). If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{list}{Character vector naming objects to be loaded from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{no_imported_objects}{Logical, whether to only return information
about imported files and targets with commands (i.e. whether to ignore
imported objects that are not files).}

\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Deprecated on 2019-09-11.}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{progress}{Character vector for filtering the build progress results.
Defaults to \code{NULL} (no filtering) to report progress of all objects.
Supported filters are \code{"done"}, \code{"running"}, and \code{"failed"}.}
}
\value{
The build progress of each target reached by
the current \code{\link[=make]{make()}} so far.
}
\description{
Objects that drake imported, built, or attempted
to build are listed as \code{"done"} or \code{"running"}.
Skipped objects are not listed.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
# Watch the changing progress() as make() is running.
progress() # List all the targets reached so far.
progress(small, large) # Just see the progress of some targets.
progress(list = c("small", "large")) # Same as above.
}
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}}, \code{\link[=drake_get_session_info]{drake_get_session_info()}},
\code{\link[=cached]{cached()}}, \code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
