% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outdated.R
\name{recoverable}
\alias{recoverable}
\title{List the most upstream \emph{recoverable} outdated targets.
\lifecycle{experimental}}
\usage{
recoverable(config, make_imports = TRUE, do_prework = TRUE)
}
\arguments{
\item{config}{A configured workflow from \code{\link[=drake_config]{drake_config()}}.}

\item{make_imports}{Logical, whether to make the imports first.
Set to \code{FALSE} to save some time and risk obsolete output.}

\item{do_prework}{Whether to do the \code{prework}
normally supplied to \code{\link[=make]{make()}}.}
}
\value{
Character vector of the names of recoverable targets.
}
\description{
Only shows the most upstream updated targets.
Whether downstream targets are recoverable depends on
the eventual values of the upstream targets in the next \code{\link[=make]{make()}}.
Does not show dynamic sub-targets.
}
\section{Recovery}{

\code{make(recover = TRUE, recoverable = TRUE)}
powers automated data recovery.
The default of \code{recover} is \code{FALSE} because
\enumerate{
\item Automated data recovery is still experimental.
\item It has reproducibility issues.
Targets recovered from the distant past may have been generated
with earlier versions of R and earlier package environments
that no longer exist.
}

How it works: if \code{recover} is \code{TRUE},
\code{drake} tries to salvage old target values from the cache
instead of running commands from the plan.
A target is recoverable if
\enumerate{
\item There is an old value somewhere in the cache that
shares the command, dependencies, etc.
of the target about to be built.
\item The old value was generated with \code{make(recoverable = TRUE)}.
}

If both conditions are met, \code{drake} will
\enumerate{
\item Assign the most recently-generated admissible data to the target, and
\item skip the target's command.
}
}

\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan)
make(my_plan)
clean()
outdated(config) # Which targets are outdated?
recoverable(config) # Which of these are recoverable and upstream?
# The report still builds because clean() removes report.md,
# but make() recovers the rest.
make(my_plan, recover = TRUE)
# When was the *recovered* small data actually built (first stored)?
# (Was I using a different version of R back then?)
diagnose(small)$date
# If you set the same seed as before, you can even
# rename targets without having to build them again.
# For an example, see
# the "Reproducible data recovery and renaming" section of
# https://github.com/ropensci/drake/blob/master/README.md.
}
})
}
}
\seealso{
\code{\link[=r_recoverable]{r_recoverable()}}, \code{\link[=r_outdated]{r_outdated()}}, \code{\link[=drake_config]{drake_config()}}, \code{\link[=missed]{missed()}},
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
