% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/insertPackage.R
\name{insertPackage}
\alias{drat:::insert}
\alias{insert}
\alias{insertPackage}
\title{Insert a package source archive into a drat repository}
\usage{
insertPackage(file, repodir = getOption("dratRepo", "~/git/drat"),
  commit = FALSE)

insert(...)
}
\arguments{
\item{file}{A source archive in \code{tar.gz} form.}

\item{repodir}{A local directory corresponding to the repository
top-leve directory.}

\item{commit}{A boolean toggle to select automatic git operations
\sQuote{add}, \sQuote{commit}, and \sQuote{push}.}

\item{...}{For the aliases variant, a catch-all collection of
parameters.}
}
\value{
NULL is returned.
}
\description{
R can use multiple archives: CRAN, BioConductor and Omegahat have
been supported for years.  It is equally easy to add local
archives from the same machine, or local network, or university /
company network as well as other publically available
repositories.  This function aids in the process, and defaults to
inserting a given source archive into a given repository.
}
\details{
This function inserts the given package file into the given
(local) package repository and updates the index. By setting the
\code{commit} option to \code{TRUE}, one can then push to a remote
git code repository. If the \code{\link[git2r]{git2r}} package is
installed, it is used for the interaction with the git repository;
otherwise the \code{git} shell command is used.

An aliased function \code{insert} is also available, but not
exported via \code{NAMESPACE} to not clobber a possibly unrelated
function; use it via \code{drat:::insert()}.
}
\author{
Dirk Eddelbuettel
}

