% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic4.R
\name{loglogistic4_gradient}
\alias{loglogistic4_gradient}
\alias{loglogistic4_hessian}
\alias{loglogistic4_gradient_hessian}
\title{4-parameter log-logistic function gradient and Hessian}
\usage{
loglogistic4_gradient(x, theta)

loglogistic4_hessian(x, theta)

loglogistic4_gradient_hessian(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Gradient or Hessian evaluated at the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
4-parameter log-logistic function.
}
\details{
The 4-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = x^eta / (x^eta + phi^eta)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi)}, \code{eta > 0}, and
\code{phi > 0}.
}
