% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{n_times}
\alias{n_times}
\alias{n_th}
\alias{n_letter}
\title{Numbers in letters}
\usage{
n_times(n)

n_th(n)

n_letter(n)
}
\arguments{
\item{n}{An integer vector.}
}
\value{
It returns a character vector of length one.
}
\description{
Set of (tiny) functions that convert integers into words.
}
\section{Functions}{
\itemize{
\item \code{n_th}: Transforms the integer \code{n} to \code{nth} appropiately.

\item \code{n_letter}: Transforms small integers to words.
}}

\examples{

find = function(v, x){
  if(x \%in\% v){
    message("The number ", n_letter(x), " appears ", n_times(sum(v == x)),
            ", the first occurrence is the ", n_th(which(v==x)[1]), " element.")
  } else message("The number ", n_letter(x), " was not found.")
}

v = sample(100, 500, TRUE)
find(v, 6)



}
\author{
Laurent Berge
}
