% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{setDreamerr_check}
\alias{setDreamerr_check}
\title{Sets dreamerr argument checking functions on or off}
\usage{
setDreamerr_check(check = TRUE)
}
\arguments{
\item{check}{Strict logical: either \code{TRUE} of \code{FALSE}. Default is \code{TRUE}.}
}
\description{
This function allows to disable, or re-enable, all calls to \code{\link[dreamerr]{check_arg}} within any function. Useful only when running (very) large loops (>100K iter.) over small functions that use dreamerr's \code{\link[dreamerr]{check_arg}}.
}
\examples{

# Let's create a small function that returns the argument
#  if it is a single character string, and throws an error
#  otherwise:

test = function(x){
  check_arg(x, "scalar character")
  x
}

# works:
test("hey")
# error:
try(test(55))

# Now we disable argument checking
setDreamerr_check(FALSE)
# works (although it shouldn't!):
test(55)

# re-setting argument checking on:
setDreamerr_check(TRUE)


}
\author{
Laurent Berge
}
