% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropagationMCC.R
\name{PropagationMCC}
\alias{PropagationMCC}
\title{Compute drought propagation based on maximum correlation}
\usage{
PropagationMCC(X, Y, acc = 12, lim = c(-1, 1), color = NA)
}
\arguments{
\item{X}{The vector of monthly meteorological variable (e.g., precipitation)}

\item{Y}{The vector of monthly hydrological variables (e.g., runoff)}

\item{acc}{Maximum of propagation time (or accumulation periods)}

\item{lim}{The limits interval for color}

\item{color}{Color vector in plot}
}
\value{
Plot of correlation matrix
}
\description{
Compute the pearson correlation between multi-time scale SPI and 1-month SRI
to reflect the most possible propagation time (PT) from
meteorological drought to hydrological drought.
Note here the propagation of meteorological to hydrological drought is used as an example.
The propagation of other types of drought  can also be computed.
}
\examples{
X=runif(120, min = 0, max = 100) # 10-year monthly data
Y=runif(120, min = 0, max = 100) # 10-year monthly data
acc <- 12
lim <- c(-1,1)
PropagationMCC(X, Y, acc, lim)
}
\references{
Xu, Y. et al (2019). Propagation from meteorological drought to hydrological drought under the impact of human activities: A case study in northern China. J. Hydrol. 579, 124147.
}
