% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{wald_test.drtmle}
\alias{wald_test.drtmle}
\title{Wald tests for drtmle objects}
\usage{
\method{wald_test}{drtmle}(object, est = c("drtmle"), null = 0, contrast = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"drtmle"}}

\item{est}{A vector indicating for which estimators to return a
confidence interval. Possible estimators include the TMLE with doubly robust
inference (\code{"drtmle"}, recommended), the AIPTW with additional
correction for misspecification (\code{"aiptw_c"}, not recommended), the
standard TMLE (\code{"tmle"}, recommended only for comparison to "drtmle"),
the standard AIPTW (\code{"aiptw"}, recommended only for comparison to
"drtmle"), and G-computation (\code{"gcomp"}, not recommended).}

\item{null}{The null hypothesis value.}

\item{contrast}{This option specifies what parameter to return confidence
intervals for. If \code{contrast=NULL}, then test the null hypothesis that
the covariate-adjusted marginal means equal the value(s) specified in
\code{null}. \code{contrast} can also be a numeric vector of ones, negative
ones, and zeros to define linear combinations of the various means (e.g., to
estimate an average treatment effect, see examples). In this case, we test
the null hypothesis that the linear combination of means equals the value
specified in \code{null}. \code{contrast} can also be a list with named
functions \code{f}, \code{h}, and \code{fh_grad}. The function \code{f}
takes as input argument \code{eff} and specifies which transformation of the
effect measure to test. The function \code{h} defines the contrast to be
estimated and should take as input \code{est}, a vector of the same length
as \code{object$a_0}, and output the desired contrast. The function
\code{fh_grad} is the gradient of the function \code{h(f())}. The function
computes a test of the null hypothesis that \code{h(f(object$est)) = null}.
See examples.}

\item{...}{Other options (not currently used).}
}
\value{
An object of class \code{"ci.drtmle"} with point estimates and
 confidence intervals of the specified level.
}
\description{
Wald tests for drtmle objects
}
\examples{
# load super learner
library(SuperLearner)
# simulate data
set.seed(123456)
n <- 100
W <- data.frame(W1 = runif(n), W2 = rnorm(n))
A <- rbinom(n, 1, plogis(W$W1 - W$W2))
Y <- rbinom(n, 1, plogis(W$W1 * W$W2 * A))
# fit drtmle with maxIter = 1 so runs fast
fit1 <- drtmle(
  W = W, A = A, Y = Y, a_0 = c(1, 0),
  family = binomial(),
  stratify = FALSE,
  SL_Q = c("SL.glm", "SL.mean", "SL.glm.interaction"),
  SL_g = c("SL.glm", "SL.mean", "SL.glm.interaction"),
  SL_Qr = "SL.glm",
  SL_gr = "SL.glm", maxIter = 1
)
# get hypothesis test that each mean = 0.5
test_mean <- wald_test(fit1, null = 0.5)

# get test that ATE = 0
test_ATE <- wald_test(fit1, null = 0, contrast = c(1, -1))

# get test that risk ratio = 1, computing test on log scale
myContrast <- list(
  f = function(eff) {
    log(eff)
  },
  f_inv = function(eff) {
    exp(eff)
  },
  h = function(est) {
    est[1] / est[2]
  },
  fh_grad = function(est) {
    c(1 / est[1], -1 / est[2])
  }
)
test_RR <- wald_test(fit1, contrast = myContrast, null = 1)
#
}
