% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimategrn_loop}
\alias{estimategrn_loop}
\title{estimategrn_loop}
\usage{
estimategrn_loop(
  validRows,
  Y,
  A,
  W,
  DeltaA,
  DeltaY,
  tolg,
  Qn,
  gn,
  glm_gr,
  SL_gr,
  a_0,
  reduction,
  returnModels,
  use_future
)
}
\arguments{
\item{validRows}{A \code{list} of length \code{cvFolds} containing the row
indexes of observations to include in validation fold.}

\item{Y}{A vector of continuous or binary outcomes.}

\item{A}{A vector of binary treatment assignment (assumed to be equal to 0 or
1).}

\item{W}{A \code{data.frame} of named covariates.}

\item{DeltaA}{Indicator of missing treatment (assumed to be equal to 0 if
missing 1 if observed).}

\item{DeltaY}{Indicator of missing outcome (assumed to be equal to 0 if
missing 1 if observed).}

\item{tolg}{A numeric indicating the minimum value for estimates of the
propensity score.}

\item{Qn}{A list of outcome regression estimates evaluated on observed data.}

\item{gn}{A list of propensity regression estimates evaluated on observed
data.}

\item{glm_gr}{A character describing a formula to be used in the call to
\code{glm} for the second reduced-dimension regression. Ignored if
\code{SL_gr!=NULL}.}

\item{SL_gr}{A vector of characters or a list describing the Super Learner
library to be used for the reduced-dimension propensity score.}

\item{a_0}{A list of fixed treatment values .}

\item{reduction}{A character equal to \code{'univariate'} for a univariate
misspecification correction or \code{'bivariate'} for the bivariate version.}

\item{returnModels}{A boolean indicating whether to return model fits for the
outcome regression, propensity score, and reduced-dimension regressions.}

\item{use_future}{Should \code{future} be used to parallelize?}
}
\description{
Helper function to clean up the internal code of \code{drtmle}
}
