% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_fit_ti}
\alias{f_fit_ti}
\title{Model Fitting for Gap Times}
\usage{
f_fit_ti(df, model = "lm", nreps, showplot = TRUE)
}
\arguments{
\item{df}{The subject-level dosing data, including the following
variables:
\itemize{
\item \code{time}: The gap time to the next drug dispensing visit.
\item \code{skipped}: The number of skipped visits.
\item \code{k1}: The covariate for the linear regression. It equals
\code{skipped} for the gap time between randomization and
the first drug dispensing visit and \code{skipped + 1}
for the gap time between two consecutive drug dispensing visits.
}}

\item{model}{The model used to analyze the gap time.
Currently, it only supports the linear model ("lm").}

\item{nreps}{The number of simulations for drawing posterior model
parameter values.}

\item{showplot}{A Boolean variable that controls whether or not to
show the fitted gap time bar chart. It defaults to \code{TRUE}.}
}
\value{
A list with three components:
\itemize{
\item \code{fit}: A list of results from the model fit that includes
\itemize{
\item \code{model}: The specific model used in the analysis.
\item \code{beta}: The estimated regression coefficient for the covariate.
\item \code{vbeta}: The estimated variance of \code{beta}.
\item \code{sigma}: The estimated residual standard deviation.
\item \code{df}: The residual degrees-of-freedom.
\item \code{aic}: The Akaike Information Criterion value.
\item \code{bic}: The Bayesian Information Criterion value.
}
\item \code{fit_plot}: A fitted gap time bar chart.
\item \code{theta}: Posterior draws of model parameters.
}
}
\description{
Fits a linear regression model to the gap times.
}
\examples{
library(dplyr)

df <- df2 \%>\%
mutate(arrivalTime = as.numeric(randdt - trialsdt + 1))

vf <- visitview2 \%>\%
  inner_join(df, by = "usubjid") \%>\%
  mutate(day = as.numeric(date - randdt + 1)) \%>\%
  select(drug, drug_name, dose_unit, usubjid, treatment,
         treatment_description, arrivalTime,
         time, event, dropout, day, dispensed_quantity) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid, treatment,
           treatment_description, arrivalTime,
           time, event, dropout, day) \%>\%
  summarise(dose = sum(dispensed_quantity), .groups = "drop_last") \%>\%
  mutate(cum_dose = cumsum(dose)) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid) \%>\%
  mutate(row_id = row_number())

vf <- vf \%>\%
  left_join(dosing_schedule_df, by = "drug")

vf1 <- vf \%>\%
  group_by(usubjid, day) \%>\%
  slice(n()) \%>\%
  group_by(usubjid) \%>\%
  mutate(row_id = row_number())

df_ti <- vf1 \%>\%
  mutate(time = lead(day) - day,
         skipped = pmax(floor((time - target_days/2)/target_days), 0),
         k1 = skipped + 1) \%>\%
  filter(row_id < n())

fit_ti <- f_fit_ti(df_ti, model = "lm", nreps = 200)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
