% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmodel.r
\name{summary.expmodel}
\alias{summary.expmodel}
\title{Summary of Exponential-based \code{expmodel} object.}
\usage{
\method{summary}{expmodel}(object, nmax = 10, estonly = FALSE, ...)
}
\arguments{
\item{object}{\code{expmodel} object.}

\item{nmax}{A number of estimates to show in the summary.
The default is 10.}

\item{estonly}{Show only the results of estimates. The default value
is \code{FALSE}.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
None.
}
\description{
Summary of \code{expmodel} object, including a mean and quantiles.
If some estimation has done, also print out estimates, up to \code{nmax}
number of them.
}
\examples{
## Create expmodel object from a data set mixexpgamma$n200
emodel <- expmodel(mixexpgamma$n200)
## Print a summary of an object
summary(emodel)
}
\seealso{
\code{\link[=expmodel]{expmodel()}} \code{\link[=plot.expmodel]{plot.expmodel()}} \code{\link[=estimate.expmodel]{estimate.expmodel()}}
}
