% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erf.R
\name{erf}
\alias{erf}
\alias{erfc}
\alias{erfinv}
\alias{erfcinv}
\alias{d1qnormdx1}
\alias{d2qnormdx2}
\title{erf function}
\usage{
erf(x)

erfc(x)

erfinv(x)

erfcinv(x)

d1qnormdx1(x)

d2qnormdx2(x)
}
\arguments{
\item{x}{vector of quantiles.}
}
\value{
Returns a vector of the corresponding function evaluated at x.
}
\description{
Error function, complementary error function, inverse error function,inverse complementary error function and first and second derivative of quantile function of the standard normal distribution.
}
\details{
\code{erf} is the error function. \code{erfc} is the complementary error function.
\code{erfinv} is the inverse error function and and \code{erfcinv} is the inverse complementary error function.
\code{d1qnormdx1} evaluates the first derivative of quantile function of the standard normal distribution w.r.t. \code{x}.
\code{d2qnormdx2} evaluates the second derivative of quantile function of the standard normal distribution w.r.t. \code{x}.
}
\section{Functions}{
\itemize{
\item \code{erfc()}: complementary error function

\item \code{erfinv()}: inverse error function

\item \code{erfcinv()}: inverse complementary error function

\item \code{d1qnormdx1()}: First derivative of quantile function of the standard normal distribution

\item \code{d2qnormdx2()}: Second derivative of quantile function of the standard normal distribution

}}
\examples{
erf(0.5)
erfc(0.5)
erfinv(0.5)
erfcinv(0.5)
d1qnormdx1(0.5)
d2qnormdx2(0.5)

}
\keyword{internal}
