% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{derivs_transform}
\alias{derivs_transform}
\title{derivs_transform}
\usage{
derivs_transform(f, type, par, tri, deriv_order)
}
\arguments{
\item{f}{derivs object.}

\item{type}{string, specifies the transformation function. Available are:
\enumerate{
\item  \code{identity}: \eqn{f(x)=x}.
\item  \code{exp}: \eqn{f(x)=\exp\{x\}}.
\item  \code{log}: \eqn{f(x)=\log\{x\}}.
\item  \code{glogit}: \eqn{f(x)=\log\{(-x + min)/(x - max)}, where \code{par=c(min, max)}.
\item  \code{glogitinv}: \eqn{f(x)=\exp\{x\} \cdot (max + min)/(1 + \exp\{x\}) }, where \code{par=c(min, max)}.
\item  \code{inv}: \eqn{f(x)=\frac{1}{x}}.
\item  \code{pnorm}: \eqn{f(x)=\Phi(x)}.
\item  \code{qnorm}: \eqn{f(x)=\Phi^{-1}(x)}.
\item  \code{mexp}: \eqn{f(x)=-\exp\{x\}}.
\item  \code{zeta}: \eqn{f(x)=\log\{2 \cdot \Phi(x)\}}.
\item  \code{constant}: \eqn{f(x)=c}.
\item  \code{chainrule_utility}: \eqn{f(x)=f'(x)=f''(x)=f'''(x)=f''''(x)}.
}}

\item{par}{numeric vector, additional parameters, e.g. min and max for \code{glogit}.}

\item{tri}{list; created by the function \code{\link[=trind_generator]{trind_generator()}}.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}
}
\value{
Returns an object of class \code{derivs}
}
\description{
Transforms a derivs object via the specified function and applies the chainrule.
}
\details{
Takes the derivs object \code{f} as an input for the function specified by \code{type} and evaluates it together with the derivatives utilizing the chainrule.
For more details see \code{\link[=trind]{trind()}} and \code{\link[=trind_generator]{trind_generator()}}.
}
\examples{
A<-matrix(c(1:9)/10, ncol=1)
A_mat<-list2derivs(list(A, A^0, A^2, A^3, A^4), deriv_order=4)
derivs_transform(f =derivs_transform(f = A, type="exp", par=0,
                                     tri=trind_generator(1), deriv_order=4),
                   type="log", par=0, tri=trind_generator(1), deriv_order=4)

}
\seealso{
Other derivs: 
\code{\link{chainrule}()},
\code{\link{differencerule}()},
\code{\link{ind2joint}()},
\code{\link{list2derivs}()},
\code{\link{productrule}()},
\code{\link{quotientrule}()},
\code{\link{sumrule}()},
\code{\link{trind_generator}()},
\code{\link{trind}()}
}
\concept{derivs}
