% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomper_mv.R
\name{dcomper_mv}
\alias{dcomper_mv}
\alias{pcomper_mv}
\alias{rcomper_mv}
\title{Multivariate Composed-Error distribution}
\usage{
dcomper_mv(
  x,
  mu = matrix(c(0, 0), ncol = 2),
  sigma_v = matrix(c(1, 1), ncol = 2),
  sigma_u = matrix(c(1, 1), ncol = 2),
  delta = matrix(0, nrow = 1),
  s = c(-1, -1),
  distr = c("normhnorm", "normhnorm", "normal"),
  rot = 0,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

pcomper_mv(
  q,
  mu = matrix(c(0, 0), ncol = 2),
  sigma_v = matrix(c(1, 1), ncol = 2),
  sigma_u = matrix(c(1, 1), ncol = 2),
  delta = 0,
  s = c(-1, -1),
  distr = c("normhnorm", "normhnorm", "normal"),
  rot = 0,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

rcomper_mv(
  n,
  mu = matrix(c(0, 0), ncol = 2),
  sigma_v = matrix(c(1, 1), ncol = 2),
  sigma_u = matrix(c(1, 1), ncol = 2),
  delta = matrix(0, nrow = 1),
  s = c(-1, -1),
  distr = c("normhnorm", "normhnorm", "normal"),
  rot = 0
)
}
\arguments{
\item{x}{numeric matrix of quantiles. Must have two columns.}

\item{mu}{numeric matrix of \eqn{\mu}. Must have two columns.}

\item{sigma_v}{numeric matrix of \eqn{\sigma_V}. Must be positive and have two columns.}

\item{sigma_u}{numeric matrix of \eqn{\sigma_U}. Must be positive and have two columns.}

\item{delta}{numeric vector of copula parameter \eqn{\delta}.}

\item{s}{integer vector of length two; each element corresponds to one marginal.}

\item{distr}{string vector of length three; the first two elements determine the distribution of the marginals. Available are:\cr
`normhnorm`, Normal-halfnormal distribution \cr
`normexp`, Normal-exponential distribution \cr
The last element determines the distribution of the copula:\cr
`independent`, Independence copula \cr
`normal`, Gaussian copula \cr
`clayton`, Clayton copula \cr
`gumbel`, Gumbel copula \cr
`frank`, Frank copula \cr
`joe`, Joe copula \cr
`amh`, Ali-Mikhail-Haq copula \cr}

\item{rot}{integer determining the rotation for Archimedian copulas. Can be \code{90}, \code{180} or \code{270}.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional; List of objects generated by [trind_generator()].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{numeric matrix of probabilities.}

\item{n}{positive integer; number of observations.}
}
\value{
\code{dcomper_mv} gives the density, \code{pcomper_mv} give the distribution function, and \code{rcomper_mv} generates random numbers, with given parameters.
If the derivatives are calculated the output is a \code{derivs} object.
}
\description{
Probablitiy density function, distribution, quantile function and random number generation for the multivariate composed-error distribution
}
\details{
A bivariate random vector \eqn{(X_1,X_2)=\boldsymbol{X}} follows a multivariate composed-errordistribution \eqn{f_{X_1,X_2}(x_1,x_2)}, which can be rewritten using Sklars' theorem via a copula
\deqn{f_{X_1,X_2}(y_1,y_2)=c(F_{X_1}(x_1),F_{X_2}(x_2),\delta) \cdot f_{X_1}(x_1) f_{X_2}(x_2) \qquad,}
where \eqn{c(\cdot)} is the density of the copula and \eqn{F_{X_m}(x_m)},\eqn{f_{X_m}(x_m)} are the marginal cdfs and pdfs respectively for \eqn{m \in \{1,2\}}. \eqn{\delta} is the copula parameter.
}
\section{Functions}{
\itemize{
\item \code{pcomper_mv()}: distribution function for the multivariate composed-error distribution.

\item \code{rcomper_mv()}: random number generation for the multivariate composed-error distribution.

}}
\examples{
pdf <- dcomper_mv(x=matrix(c(0,10),ncol=2), mu=matrix(c(1,2),ncol=2),
                  sigma_v=matrix(c(3,4),ncol=2), sigma_u=matrix(c(5,6),ncol=2),
                  delta=c(0.5), s=c(-1,-1), distr=c("normhnorm","normhnorm","normal"),
                  deriv=2 ,
                  tri=list(trind_generator(3),trind_generator(3),trind_generator(1),
                  trind_generator(6),trind_generator(7)), 
                  log.p=TRUE)
cdf <- pcomper_mv(q=matrix(c(0,10),ncol=2), mu=matrix(c(1,2),ncol=2),
                  sigma_v=matrix(c(3,4),ncol=2), sigma_u=matrix(c(5,6),ncol=2),
                  delta=c(0.5), s=c(-1,-1), distr=c("normhnorm","normhnorm","normal"))
r <- rcomper_mv(n=10, mu=matrix(c(1,2),ncol=2),
                sigma_v=matrix(c(3,4),ncol=2), sigma_u=matrix(c(5,6),ncol=2),
                delta=c(0.5), s=c(-1,-1), distr=c("normhnorm","normhnorm","normal"))

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
\item \insertRef{gradshteyn2014table}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
\seealso{
Other distribution: 
\code{\link{dcomper}()},
\code{\link{dnormexp}()},
\code{\link{dnormhnorm}()}
}
\concept{distribution}
