% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_bounds.R
\name{delta_bounds}
\alias{delta_bounds}
\title{Bounds of Copula Parameter delta}
\usage{
delta_bounds(distr)
}
\arguments{
\item{distr}{string, defines the copula family:\cr
`independent` = Independence copula \cr
`normal` = Gaussian copula \cr
`clayton` = Clayton copula \cr
`gumbel` = Gumbel copula \cr
`frank` = Frank copula \cr
`joe` = Joe copula \cr
`amh` = Ali-Mikhail-Haq copula \cr}
}
\value{
Returns numeric vector of length two with first argument being the minimum and the second argument being the maximum of the parameter space.
}
\description{
Provides the minimum and maximum of the parameter space for \eqn{\delta}
}
\details{
Although the parameter space is larger in theory for some copulas, numeric under- and overflow limits the parameter space. The parameter space of \eqn{\delta} is specified for each copula below: 
\itemize{
\item  `independent`, min=0 and max=1
\item  `normal`, min=-1 and max=1
\item  `clayton`, min=1e-16 and max=28
\item  `gumbel`, min=1 and max=17
\item  `frank`, min=-35 and max=35
\item  `joe`, min=1e-16 and max=30
\item  `amh`, min=-1 and max=1
}
}
\examples{
delta_bounds("normal")

}
\seealso{
Other copula: 
\code{\link{cop}()},
\code{\link{dcop}()}
}
\concept{copula}
