% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqgam.check.R
\name{rqgam.check}
\alias{rqgam.check}
\title{Randomised quantile residuals check plots for GAMs/DSMs}
\usage{
rqgam.check(gam.obj, ...)
}
\arguments{
\item{gam.obj}{a \code{gam}, \code{glm} or \code{dsm} object.}

\item{...}{arguments passed on to all plotting functions}
}
\value{
just plots!
}
\description{
Function operates as \code{\link{gam.check}} but using randomised quantile
residuals, a la Dunn and Smyth (1996). Checks of \code{k} are not computed,
these need to be done using \code{\link{gam.check}}.
}
\details{
In general plots other than residuals vs. linear predictors should be interpreted with caution (for example Q-Q plots and histogram of residuals will look normal by construction -- so there is no model checking information).

Note that this function only works with negative binomial and Tweedie response distributions.
}
\examples{
\donttest{
library(Distance)
library(dsm)
library(tweedie)

# load the Gulf of Mexico dolphin data (see ?mexdolphins)
data(mexdolphins)
attach(mexdolphins)

# fit a detection function and look at the summary
hr.model <- ds(distdata, max(distdata$distance),
               key = "hr", adjustment = NULL)

# fit a simple smooth of x and y with a Tweedie response with estimated
#  p parameter
mod1<-dsm(N~s(x,y), hr.model, segdata, obsdata, family=tw())
rqgam.check(mod1)

# detach the data
detach("mexdolphins")
}
}
\author{
Based on code provided by Natalie Kelly, bugs added by Dave Miller
}

