# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Subgraphs in Undirected Graphs/Networks
#' 
#' Finding and indexing subgraphs in undirected graph.
#' 
#' Input is given as two vectors where each pair of node ids `id_1[i]` - `id_2[i]` indicates an 
#' edge between two nodes. 
#' 
#' @param id_1 vector of integers indicating ids 
#' @param id_2 vector of integers indicating ids 
#' @param verbose in integer indicating the amount of verbosity; good for long running tasks or to 
#'   get more information about the workings of the algorithm; currently accepted values: 0, 1, 2
#' 
#' @return An integer vector with subgraph ids such that each distinct subgraph - i.e. all 
#'   nodes are reachable within the graph and no node outside the subgraph is reachable - 
#'   gets a distinct integer value. Integer values are assigned via 
#'
#' @examples
#' 
#' graphs_find_subgraphs(c(1,2,1,5,6,6), c(2,3,3,4,5,4), verbose = 0)
#' graphs_find_subgraphs(c(1,2,1,5,6,6), c(2,3,3,4,5,4), verbose = 2)
#'
#' @export
#' 
graphs_find_subgraphs <- function(id_1, id_2, verbose = 1L) {
    .Call('_dsmisc_graphs_find_subgraphs', PACKAGE = 'dsmisc', id_1, id_2, verbose)
}

